#============================================================================== 
# ** Classes.Linked_List                                             By: Zeriab
#------------------------------------------------------------------------------
# Description:
# ------------
# This class represents a double linked list. Has a reference to the tail
# and the head of the list.
#  
# Method List:
# ------------
# []=
# add
# insert
# push
# <<
# unshift
# delete
# pop
# shift
# get
# []
# size=
# insert_element
# insert_element_tail
# delete_element
# search
# get_element
#
#  Linked_List::Element
#  --------------------
#  value=
#  value
#  previous_element=
#  previous_element
#  next_element=
#  next_element
#==============================================================================

MACL::Loaded << 'Classes.Linked_list'

#==============================================================================
# ** Linked_List
#==============================================================================

class Linked_List
  #--------------------------------------------------------------------------
  # * Public Instance Variables
  #--------------------------------------------------------------------------
  attr_accessor :head
  attr_accessor :tail
  attr_reader   :size
  #--------------------------------------------------------------------------
  # * Object Initialization
  #--------------------------------------------------------------------------
  def initialize
    self.size = 0
  end
  #--------------------------------------------------------------------------
  # * []=
  # Change the value of the nth element in the list
  # Return true if the change succeeds otherwise false
  #--------------------------------------------------------------------------
  def []=(n, value)
    # Return nil if the list is empty
    element = get_element(n)
    if element.nil?
      return false
    else
      element.value = value
      return true
    end
  end
  #--------------------------------------------------------------------------
  # * Add
  # Add an object to the list (HEAD)
  #--------------------------------------------------------------------------
  def add(value)
    element = Linked_List::Element.new
    element.value = value
    insert_element(element)
    self.size += 1
  end
  # Synonyms
  def insert(value) add(value) end
  def push(value)   add(value) end
  def <<(value)     add(value) end
  #--------------------------------------------------------------------------
  # * Unshift
  # Add an object to the back of the list (TAIL)
  #--------------------------------------------------------------------------
  def unshift(value)
    element = Linked_List::Element.new
    element.value = value
    insert_element_tail(element)
    self.size += 1
  end
  #--------------------------------------------------------------------------
  # * Delete
  # Delete an object from the list
  # Return the deleted object
  # Return nil if the deletion has no effect on the list.
  #--------------------------------------------------------------------------
  def delete(value)
    element = self.search(value)
    if element.nil?
      return nil
    else
      self.delete_element(element)
      self.size -= 1
      return element.value
    end
  end
  #--------------------------------------------------------------------------
  # * Pop
  # Delete and return the head of the list.
  #--------------------------------------------------------------------------
  def pop
    # Return nil if the list is empty
    if self.head.nil?
      return nil
    end
    self.size -= 1
    return delete_element(self.head).value
  end
  #--------------------------------------------------------------------------
  # * Shift
  # Delete and return the tail of the list.
  #--------------------------------------------------------------------------
  def shift
    # Return nil if the list is empty
    if self.head.nil?
      return nil
    end
    self.size -= 1
    return delete_element(self.tail).value
  end
  #--------------------------------------------------------------------------
  # * Get
  # Get the object at the nth element in the list
  #--------------------------------------------------------------------------
  def get(n)
    # Return nil if the list is empty
    element = get_element(n)
    if element.nil?
      return nil
    end
    return element.value
  end
  # Synonyms
  def [](n) get(n) end
  #--------------------------------------------------------------------------
  # * Private Method
  #--------------------------------------------------------------------------
  private
  #--------------------------------------------------------------------------
  # * Size
  # Sets the size of the list
  #--------------------------------------------------------------------------
  def size=(value)
    @size = value if value >= 0
  end
  #--------------------------------------------------------------------------
  # * Insert Element
  # Insert an element into the list.
  # Assumes 'element' is a Linked_List::Element.
  #--------------------------------------------------------------------------
  def insert_element(element)
    if head.nil?
      self.head = element
      self.tail = element
      return
    end
    element.next_element = self.head
    self.head.previous_element = element
    self.head = element
    element.previous_element = nil
  end
  #--------------------------------------------------------------------------
  # * Insert Element Tail
  # Insert an element into the list at the tail.
  # Assumes 'element' is a Linked_List::Element.
  #--------------------------------------------------------------------------
  def insert_element_tail(element)
    if head.nil?
      self.head = element
      self.tail = element
      return
    end
    element.previous_element = self.tail
    self.tail.next_element = element
    self.tail = element
    element.next_element = nil
  end
  #--------------------------------------------------------------------------
  # * Delete Element
  # Delete the given element from the list
  # Assumes 'element' is a Linked_List::Element.
  #--------------------------------------------------------------------------
  def delete_element(element)
    if element.next_element.nil?
      self.tail = element.previous_element
    else
      element.next_element.previous_element = element.previous_element
    end
    if element.previous_element.nil?
      self.head = element.next_element
    else
      element.previous_element.next_element = element.next_element
    end
    return element
  end
  #--------------------------------------------------------------------------
  # * Search
  # Search for an element with the specified value.
  # Return the first element found with the corresponding value
  # Return nil if no element is found.
  #--------------------------------------------------------------------------
  def search(value)
    # If the head is nil the list is empty
    if self.head.nil?
      return nil
    end
    # Start with the head
    element = self.head
    loop do
      # Check if the element has the correct value
      if element.value == value
        return element
      end
      # Return nil if the tail has been reached
      if element == self.tail
        return nil
      end
      # Look at the next element in the list
      element = element.next_element
    end
  end
  #--------------------------------------------------------------------------
  # * Get Element
  # Get the object at the nth element in the list
  #--------------------------------------------------------------------------
  def get_element(n)
    # Return nil if the list is empty
    if self.head.nil?
      return nil
    end
    element = self.head
    for i in 0...n
      if self.tail == element
        return nil
      end
      element = element.next_element
    end
    return element
  end
end

#==============================================================================
# ** Linked_List::Element
#==============================================================================

class Linked_List::Element
  attr_accessor :value
  attr_accessor :previous_element
  attr_accessor :next_element
end